<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixExportNotificationTypeToSystem extends Migration
{
    public function up(): void
    {
        $export = NotificationType::query()->where('via', 'web')->where('action', 'export')->first();

        if (! is_null($export) && is_a($export, NotificationType::class) && $export->type !== 'system') {
            $export->type = 'system';
            $export->save();
        }
    }
}
