<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSendinblueSmsQuotas extends Migration
{
    public function up(): void
    {
        Schema::create(
            'sms_quotas',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('sms_count')->default(0);
                $table->timestamps();
            }
        );

        Schema::create(
            'sendinblue_plans',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->float('used_credits')->default(0.0);
                $table->float('remaining_credits')->default(0.0);
                $table->date('start_date');
                $table->date('end_date');
                $table->timestamps();
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('sendinblue_plans');
        Schema::dropIfExists('sms_quotas');
    }
}
