<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationRoleTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('inside_notification_role')) {
            Schema::create(
                'inside_notification_role',
                function (Blueprint $table) {
                    $table->increments('id')->collate('utf8');
                    $table->integer('notification_id')->collate('utf8')->unsigned();
                    $table->integer('role_id')->collate('utf8')->unsigned();

                    $table->foreign('notification_id')->references('id')->on('inside_notifications')->onDelete('cascade');
                    $table->foreign('role_id')->references('id')->on('inside_roles')->onDelete('cascade');

                    $table->unique(['role_id', 'notification_id'], 'notification_role_unique');
                }
            );

            Inside\Notify\Models\Notification::with('trigger')
                ->whereNull('user_uuid')
                ->get()
                ->each(
                    function ($notification) {
                        $roleIds = $notification->trigger->roles->pluck('id');
                        foreach ($roleIds as $roleId) {
                            Inside\Notify\Models\NotificationRole::firstOrCreate(
                                [
                                    'notification_id' => $notification->id,
                                    'role_id' => $roleId,
                                ]
                            );
                        }
                    }
                );
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_notification_role');
    }
}
