<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsPushDevicesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'inside_notifications_push_devices',
            function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->uuid('onesignal_player_id')->collate('utf8');
                $table->uuid('user_uuid')->collate('utf8');
                $table->enum('type', ['mobile', 'desktop']);

                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');

                $table->unique(['user_uuid', 'onesignal_player_id'], 'notifications_push_devices_unique');

                $table->index(['user_uuid']);
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_notifications_push_devices');
    }
}
