<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Authentication\Models\User as AuthenticationUser;
use Inside\Content\Models\Contents\Users as ContentUser;
use Inside\Notify\Models\Notification;
use Inside\Permission\Models\User as PermissionUser;

class AddLangcodeToNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table(
            'inside_notifications',
            function (Blueprint $table) {
                $table->char('notifiable_langcode', 2)->after('notifiable_uuid')->nullable()->default(null);
            }
        );

        // Retroactivity
        $notifications = Notification::whereNull('notifiable_langcode')->get();
        $notifications->each(
            function ($notification) {
                if (! in_array(
                    $notification->notifiable_type,
                    [ContentUser::class, PermissionUser::class, AuthenticationUser::class]
                )
                    && ($notification->notifiable !== null)
                ) {
                    $notification->notifiable_langcode = $notification->notifiable->langcode;
                    $notification->save();
                }
            }
        );
    }

    public function down(): void
    {
        Schema::table(
            'inside_notifications',
            function (Blueprint $table) {
                $table->dropColumn('notifiable_langcode');
            }
        );
    }
}
