<?php

use Illuminate\Database\Migrations\Migration;

class FixReportOnDocumentEmail extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix report
        Inside\Notify\Models\NotificationType::where([
            ['via', '=', 'email'],
            ['default', '=', true],
            ['event', '=', 'Inside\Notify\Events\CustomNotificationListener'],
            ['model', '=', 'Inside\Content\Models\Contents\Documents'],
            ['action', '=', 'report'],
            ['condition', '=', 'author:CURRENT_USER'],
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['url'] = 'GED:folders';
            $data['fields'] = ['title'];
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
