<?php

use Illuminate\Database\Migrations\Migration;

class FixPendingNewsEmail extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix like
        Inside\Notify\Models\NotificationType::where([
            'via'       => 'email',
            'default'   => false,
            'event'     => 'Inside\Content\Events\ContentCreatedEvent',
            'model'     => 'Inside\Content\Models\Contents\News',
            'action'    => 'create',
            'condition' => 'status:2',
            'multiple'  => false,
            'language'  => true,
            'profile'   => false,
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['fields'] = [
                'title',
            ];
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
