<?php

use Illuminate\Database\Migrations\Migration;

class FixReportObsoleteDocumentWeb extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix like
        Inside\Notify\Models\NotificationType::where([
            'via'       => 'web',
            'default'   => false,
            'event'     => 'Inside\Notify\Events\CustomNotificationListener',
            'model'     => 'Inside\Content\Models\Contents\Documents',
            'action'    => 'report',
            'condition' => '',
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['fields'] = [
                ['notification-data.from' => ['firstname', 'lastname']],
                'title',
                ['folders' => ['uuid', 'title']],
            ];
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
