<?php

use Illuminate\Database\Migrations\Migration;

class FixLikeWeb extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix like
        Inside\Notify\Models\NotificationType::where([
            ['via', '=', 'web'],
            ['default', '=', true],
            ['event', '=', 'Inside\Reaction\Events\ReactionSubscribedEvent'],
            ['model', '=', ''],
            ['action', '=', 'like'],
            ['condition', '=', 'author:CURRENT_USER'],
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['fields'] = [['notification-data.from' => ['firstname', 'lastname']], ['structures' => ['title', 'slug']]];
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
