<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class FixCarbonintervalFormatTable extends Migration
{
    protected array $convert = [
        'M1D'   => '-P1D',
        'M7D'   => '-P7D',
        'MT23H' => '-PT23H',
        'MT1H'  => '-PT1H',
        'M23H' => '-PT23H',
        'M1H'  => '-PT1H',
    ];

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        foreach ($this->convert as $from => $to) {
            Inside\Notify\Models\NotificationType::each(function ($notificationType) use ($from, $to) {
                $notificationType->data = str_replace($from, $to, $notificationType->data);
                $notificationType->save();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
