<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsSubscribersTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('inside_notifications_subscribers')) {
            Schema::create('inside_notifications_subscribers', function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->uuid('user_uuid')->collate('utf8');
                $table->integer('notification_type_id')->collate('utf8')->unsigned();

                $table->foreign('notification_type_id')->references('id')->on('inside_notifications_types')->onDelete('cascade');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');

                $table->unique(['user_uuid', 'notification_type_id'], 'notifications_subscribers_unique');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_notifications_subscribers');
    }
}
