<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('inside_notifications')) {
            Schema::create('inside_notifications', function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->integer('notification_type_id')->collate('utf8')->unsigned();
                $table->uuid('user_uuid')->collate('utf8');
                $table->string('notifiable_type', 255);
                $table->uuid('notifiable_uuid')->collate('utf8');
                $table->text('data');
                $table->timestamp('view_at')->nullable();
                $table->timestamp('read_at')->nullable();
                $table->timestamps();

                $table->foreign('notification_type_id')->references('id')->on('inside_notifications_types')->onDelete('cascade');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');

                $table->index(['user_uuid']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_notifications');
    }
}
