<?php

return [
    'build_url_callbacks' => [
        'jobs_offers' => function ($model) {
            return "jobs?modal=job-offers&contentType=jobs_offers&uuid=$model->uuid&size=m";
        },
    ],
    'lifetimes' => [
        'global' => env('INSIDE_NOTIFICATION_GLOBAL_LIFETIME', 6), // global notification life time in month
        'activity' => env('INSIDE_NOTIFICATION_ACTIVITY_LIFETIME', 3), // activity notification life time in month
    ],
    'system_notifications' => [
        'system',
    ],
    'subject_prefix' => env('INSIDE_EMAIL_SUBJECT_PREFIX', env('APP_NAME').' - '),
    'manual_notifications' => [
        'enabled' => env('INSIDE_MANUAL_NOTIFICATION_ENABLED', false),
        // parameter to disable manual notifications contents
        'disabled_types' => [
            'newsletters',
            'groups',
            'users',
        ],
        'enabled_types' => is_string($enabledTypes = env('INSIDE_MANUAL_NOTIFICATION_TYPES', []))
            ? explode(',', $enabledTypes)
            : $enabledTypes,
        'contents_url_field' => [
            'external_notifications' => 'external_notif_link',
        ],
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo',
                ],
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo',
                ],
            ],
            'external_notifications' => [
                'fields' => [
                    'image',
                ],
            ],
        ],
        'custom_url' => function ($channel, $type, $uuid) {
            if ($type !== 'jobs_offers') {
                return null;
            }

            return 'CUSTOM:jobs_offers';
        },
    ],
    'override_message_builder' => env('OVERRIDE_MESSAGE_BUILDER', true),
    'email_following_users' => false,
    'ged' => [
        'url' => env('INSIDE_NOTIFICATION_GED_URL', 'ged'),
        'query' => env('INSIDE_NOTIFICATION_GED_QUERY', 'folder'),
        'root_content_type' => env('INSIDE_NOTIFICATION_GED_ROOT_CONTENT_TYPE', 'folders'),
    ],
    'cleaner' => [
        'enabled' => env('CLEAN_EXPIRED_NOTIFICATIONS', true),
        'viewed_notifications_expiry_days' => 15,
        'notifications_expiry_days' => 30,
    ],
];
