<?php

use Illuminate\Support\Facades\Route;
use Inside\Menu\Http\Controllers\Create;
use Inside\Menu\Http\Controllers\Delete;
use Inside\Menu\Http\Controllers\Links;
use Inside\Menu\Http\Controllers\Update;
use Inside\Menu\Http\Controllers\UpdateLinks;

Route::group(
    [
        'prefix'     => 'api/v1',
        'middleware' => ['auth.backoffice.access:menu'],
    ],
    function ($router) {
        $router->get('admin/menu/{menuName}', Links::class);
        $router->post('admin/menu/{menuName}', Create::class);
        $router->patch('admin/menu/{menuName}', UpdateLinks::class);
        $router->put('admin/menu/{menuName}/{uuid}', Update::class);
        $router->delete('admin/menu/{menuName}/{uuid}', Delete::class);
    }
);

Route::group(
    [
        'prefix'     => 'api/v1',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('menu/{menuName}', Links::class);
    }
);
