<?php

namespace Inside\Menu\Validation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Lang;

/**
 * Class MenuParentExists
 */
class MenuParentExists implements Rule
{
    /**
     * Validation rules
     */
    public function passes($attribute, $value): bool
    {
        if (! is_array($value)) {
            return false;
        }

        if (! array_key_exists('menu_name', $value) || ! array_key_exists('parent_uuid', $value)) {
            return false;
        }

        if (is_null($value['parent_uuid'])) {
            return true;
        }

        $menuLink = call_user_func(menu_type_to_class($value['menu_name']).'::find', $value['parent_uuid']);

        if (! $menuLink) {
            return false;
        }

        return true;
    }

    /**
     * Get the validation error message.
     */
    public function message(): string
    {
        return Lang::get('validation.invalid_menu_parent');
    }
}
