<?php

namespace Inside\Menu\Providers;

use Inside\Menu\Contracts\Menu as MenuContract;
use Inside\Menu\Events\MenuCreatedEvent;
use Inside\Menu\Events\MenuDeletedEvent;
use Inside\Menu\Services\MenuService;
use Inside\Permission\Exodus\Listeners\CreateAndGrantPrivilegesOnNewMenu;
use Inside\Permission\Exodus\Listeners\RemovePrivilegesOnDeleteMenu;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class MenuServiceProvider extends BaseServiceProvider
{
    public array $bindings = [
        MenuContract::class => MenuService::class,
    ];

    protected array $listen = [
        MenuCreatedEvent::class => [
            CreateAndGrantPrivilegesOnNewMenu::class,
        ],
        MenuDeletedEvent::class => [
            RemovePrivilegesOnDeleteMenu::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/menu.php', 'menu');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
