<?php

namespace Inside\Menu\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Menu\Events\MenuCreatedEvent;
use Inside\Menu\Events\MenuDeletedEvent;
use Inside\Support\Str;

/**
 * Inside Form Answer model.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 * @property string $uuid
 * @property string $title
 * @property string $langcode
 * @property int $weight
 * @property string $parent_uuid
 */
abstract class MenuLink extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = null;

    protected $primaryKey = 'uuid';

    protected $keyType = 'string';

    public $incrementing = false;

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'status' => 'boolean',
        'open_in_new_tab' => 'boolean',
        'hide_on_mobile' => 'boolean',
    ];

    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'langcode',
        'link',
        'status',
        'display',
        'icon',
        'image',
        'color',
        'weight',
        'page',
        'page_params',
        'open_in_new_tab',
        'hide_on_mobile',
    ];

    protected static function boot(): void
    {
        parent::boot();

        static::creating(function ($model) {
            if ($model->getKey() === null) {
                $model->setAttribute($model->getKeyName(), Str::uuid()->toString());
            }
        });

        static::created(function ($model) {
            MenuCreatedEvent::dispatch($model);
        });

        static::deleted(function ($model) {
            MenuDeletedEvent::dispatch($model);
        });
    }
}
