<?php

namespace Inside\Menu\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Menu\Contracts\Menu;

class UpdateLinks extends Controller
{
    public function __invoke(Request $request, Menu $menu, string $menuName): JsonResponse
    {
        $this->checkArguments($menuName);

        $rules = [
            'links' => 'required|array',
        ];

        $this->validate($request, $rules);

        $links = $request->get('links');

        $this->updateLinks($menu, $menuName, $links);

        return $this->success($menu);
    }

    protected function updateLinks(Menu $menu, string $menuName, array $links, string $parentUuid = null): void
    {
        $weight = 0;

        foreach ($links as $link) {
            $link['weight'] = $weight++;
            $link['parent_uuid'] = [
                'menu_name' => $menuName,
                'parent_uuid' => $parentUuid,
            ];

            $menu->move($menuName, $link['uuid'], $link);

            if (array_key_exists('children', $link) && ! empty($link['children'])) {
                $this->updateLinks($menu, $menuName, $link['children'], $link['uuid']);
            }
        }
    }
}
