<?php

namespace Inside\Menu\Contracts;

use Inside\Menu\Models\MenuLink;

interface Menu
{
    public function create(string $menuName, array $data): MenuLink;

    public function move(string $menuName, string $uuid, array $data): MenuLink;

    public function update(string $menuName, string $uuid, array $data): MenuLink;

    public function delete(string $menuName, string $uuid): void;

    public function getMenuLinks(string $menuName, string $langcode, bool $admin = false, string $parent = null, bool $getChildren = true): array;

    public function transformLink(array &$menuLink): void;

    public function uploadImage(array &$data): void;
}
