<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

final class AddHideOnMobileToMenu extends Migration
{
    public function up(): void
    {
        $menus = ['header', 'footer'];

        foreach ($menus as $menu) {
            $tableName = menu_type_to_table($menu);

            if (! Schema::hasTable($tableName)) {
                continue;
            }

            Schema::table($tableName, function (Blueprint $table) {
                $table->boolean('hide_on_mobile')->default(false);
            });
        }
    }

    public function down(): void
    {
        $menus = ['header', 'footer'];

        foreach ($menus as $menu) {
            $tableName = menu_type_to_table($menu);

            if (! Schema::hasTable($tableName)) {
                continue;
            }

            Schema::table($tableName, function (Blueprint $table) {
                $table->dropColumn('hide_on_mobile');
            });
        }
    }
}
