<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenuTables extends Migration
{
    public function up(): void
    {
        $menus = [
            'header',
            'footer',
            //            'profile',
            //            'icon'
        ];

        foreach ($menus as $menu) {
            $tableName = menu_type_to_table($menu);

            if (Schema::hasTable($tableName)) {
                continue;
            }

            Schema::create($tableName, function (Blueprint $table) use ($tableName) {
                $table->increments('id');
                $table->string('title', 255);
                $table->char('langcode', 2);
                $table->string('link', 255);
                $table->boolean('status')->default(true);
                $table->enum('display', ['title_only', 'icon_title', 'icon_only', 'image', 'button']);
                $table->string('icon', 255)->nullable();
                $table->string('image', 255)->nullable();
                $table->string('color', 7)->nullable();
                $table->integer('weight')->default(0);
                $table->integer('parent_id')->unsigned()->nullable()->default(null);
                $table->string('page', 255)->nullable();
                $table->string('page_params', 255)->nullable();
                $table->foreign('parent_id')->references('id')->on($tableName)->onDelete('set null');
            });
        }
    }

    public function down(): void
    {
        $menus = [
            'header',
            'footer',
            //            'profile',
            //            'icon'
        ];

        foreach ($menus as $menu) {
            $tableName = 'inside_menu_'.$menu;

            Schema::drop($tableName);
        }
    }
}
