<?php

namespace Inside\Layout\Transformers;

use Inside\Layout\Models\Layout;
use League\Fractal\TransformerAbstract;

class LayoutTransformer extends TransformerAbstract
{
    /**
     * @param Layout $layout
     * @return array
     */
    public function transform(Layout $layout): array
    {
        $paths = [];
        foreach ($layout->paths->all() as $path) {
            $paths[] = array_filter([
                'path'     => $path->path,
                'langcode' => $path->langcode,
            ]);
        }

        return array_filter([
            'id'     => (int) $layout->id,
            'name'   => (string) $layout->name,
            'blocks' => (string) $layout->blocks,
            'layout' => (string) $layout->layout,
            'path'   => $paths,
            'option'   => $layout->option,
        ]);
    }
}
