<?php

namespace Inside\Layout\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property Layout $layout
 *
 * @mixin Builder
 */
class LayoutPath extends Model
{
    protected $table = 'inside_layouts_paths';

    protected $fillable = ['path', 'langcode'];

    protected $hidden = ['layout_id'];

    public $timestamps = false;

    /**
     * @return BelongsTo
     */
    public function layout(): BelongsTo
    {
        return $this->belongsTo(Layout::class);
    }
}
