<?php

namespace Inside\Layout\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property Collection $paths
 * @property int $id
 * @property ?string $name
 * @property string $blocks
 * @property ?string $option
 * @property string $layout
 *
 *
 * @mixin Builder
 */
class Layout extends Model
{
    protected $table = 'inside_layouts';

    protected $fillable = ['blocks', 'layout', 'option', 'name'];

    protected $guarded = ['id'];

    public $timestamps = false;

    /**
     * @return HasMany
     */
    public function paths(): HasMany
    {
        return $this->hasMany(LayoutPath::class);
    }
}
