<?php

namespace Inside\Layout\Exceptions;

use Exception;

class NeedRedirectToLayout extends Exception
{
    /**
     * @var string
     */
    protected $path;

    /**
     * @var string
     */
    protected $langcode;

    /**
     * @param string $path
     * @param string $langcode
     */
    public function __construct(string $path, string $langcode)
    {
        parent::__construct('Asked layout is not available in this language but available in an other one');
        $this->path = $path;
        $this->langcode = $langcode;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @return string
     */
    public function getLangcode(): string
    {
        return $this->langcode;
    }
}
