<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLayoutsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inside_layouts', function (Blueprint $table) {
            $table->increments('id')->collate('utf8');
            $table->longText('blocks')->nullable();
            $table->longText('layout');
            $table->string('name', 255)->nullable();
        });

        Schema::create('inside_layouts_paths', function (Blueprint $table) {
            $table->increments('id')->collate('utf8');
            $table->integer('layout_id')->collate('utf8')->unsigned();
            $table->string('path', 255);
            $table->longText('option')->nullable();
            $table->foreign('layout_id')->references('id')->on('inside_layouts')->onDelete('cascade');
            $table->index('path');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_layouts_paths');
        Schema::dropIfExists('inside_layouts');
    }
}
