<?php

namespace Inside\Kernel\Filesystem;

use Illuminate\Support\Facades\Storage;
use Inside\Kernel\Exception\FileNotFoundException;
use Symfony\Component\HttpFoundation\StreamedResponse;

final class FileStreamService
{
    private string $disk = 'local';

    public function setDisk(string $disk): self
    {
        $this->disk = $disk;

        return $this;
    }

    public function streamFile(string $path): StreamedResponse
    {
        $filesystem = Storage::disk($this->disk);
        if (! $filesystem->exists($path)) {
            throw new FileNotFoundException(sprintf(
                'Requested file (%s) not found into the disk %s', $path, $this->disk
            ));
        }

        $filename = basename($path);
        $headers = [
            'Content-Type' => $filesystem->mimeType($path),
            'Content-Disposition' => "inline; filename=\"{$filename}\"",
        ];

        if ($filesystem->mimeType($path) == 'application/pdf') {
            $headers['Accept-Ranges'] = 'none';
        }

        return response()->stream(function () use ($path, $filesystem) {
            readfile($filesystem->path($path));
        }, 200, $headers);
    }
}
