<?php

namespace Inside\Kernel\Filesystem\Facades;

use Illuminate\Support\Facades\Facade;
use Inside\Kernel\Filesystem\FileStreamerService;
use Symfony\Component\HttpFoundation\StreamedResponse;

/**
 * @method static StreamedResponse streamFile(string $path)
 * @method static StreamedResponse streamLocalFile(string $absolutePath)
 * @method static FileStreamerService setDisk(string $disk)
 */
final class FileStreamer extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return FileStreamerService::class;
    }
}
