<?php

namespace Inside\Kernel\Authentication;

use Inside\Host\Exodus\Enum\BaseExtendedEnum;

final class SingleSignOnProviderEnum extends BaseExtendedEnum
{
    public const OKTA = 'okta';

    public const SAML = 'saml';

    public const OAUTH2 = 'oauth2';

    public const GOOGLE = 'google';

    public const WINDOWS = 'windows';

    public const CREDENTIALS = 'credentials';

    public static function getLoginUrl(string $provider): string
    {
        return match ($provider) {
            self::OKTA => '/okta/login',
            self::SAML => '/saml/login',
            self::OAUTH2 => '/oauth2/login',
            self::GOOGLE => '/google/login',
            self::WINDOWS => '/windows/login',
            default => '/login',
        };
    }

    public static function getLogoutUrl(string $provider): string
    {
        return match ($provider) {
            self::OAUTH2 => '/oauth2/logout',
            default => '/logout',
        };
    }
}
