<?php

namespace Inside\Kernel\Authentication\Actions;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Inside\Authentication\Facades\Authentication;
use Inside\Authentication\Models\User;

final class SetMagicCookie
{
    public function execute(Request $request, User $user, string $provider): void
    {
        if (Cookie::has('_inside_token')) {
            return;
        }

        $token = $user->createToken($provider, longerLifetime: true)->plainTextToken;

        Authentication::setUserToMagicCookie($request, $user, $token, force: true, remember: true);
    }
}
