<?php

declare(strict_types=1);

namespace Inside\I18n\Services;

use Illuminate\Support\Arr;
use Illuminate\Translation\FileLoader as LaravelFileLoader;
use RuntimeException;

/**
 * Class FileLoader
 */
final class FileLoader extends LaravelFileLoader
{
    /**
     * @param string $locale
     * @return array|mixed
     */
    protected function loadJsonPaths($locale)
    {
        return collect(array_merge($this->jsonPaths, [$this->path]))->reduce(
            function ($output, $path) use ($locale) {
                if ($this->files->exists($full = "{$path}/{$locale}.json")) {
                    $decoded = json_decode($this->files->get($full), true);
                    if (is_array(Arr::first($decoded))) {
                        // Detect a front file
                        $decoded = collect(Arr::dot($decoded))->mapWithKeys(
                            function ($value, $key) {
                                return ['front::'.$key => $value];
                            }
                        )->toArray();
                    }

                    if (is_null($decoded) || json_last_error() !== JSON_ERROR_NONE) {
                        throw new RuntimeException(
                            "Translation file [{$full}] contains an invalid JSON structure."
                        );
                    }

                    $output = array_merge($output, $decoded);
                }

                return $output;
            },
            []
        );
    }
}
