<?php

declare(strict_types=1);

namespace Inside\I18n\Loaders;

/**
 * Class Loader
 *
 * Main inside loader
 */
final class Loader extends AbstractLoader
{
    public function __construct(
        string $defaultLocale,
        protected array $loaders = []
    ) {
        parent::__construct($defaultLocale);
    }

    public function loadSource(string $locale, string $group, ?string $namespace = '*'): array
    {
        $sources = [];
        foreach ($this->loaders as $loader) {
            $sources = array_replace_recursive($sources, $loader->loadSource($locale, $group, $namespace));
        }

        return $sources;
    }

    /**
     * @param string $path
     */
    public function addJsonPath($path): void
    {
        foreach ($this->loaders as $loader) {
            $loader->addJsonPath($path);
        }
    }

    /**
     * @param string $namespace
     * @param string $hint
     */
    public function addNamespace($namespace, $hint)
    {
        $this->namespaces[$namespace] = $hint;

        foreach ($this->loaders as $loader) {
            $loader->addNamespace($namespace, $hint);
        }
    }
}
