<?php

declare(strict_types=1);

namespace Inside\I18n\Loaders;

use Illuminate\Support\Str;

/**
 * Class JsonLoader
 */
final class JsonLoader extends FileLoader
{
    public function loadSource(string $locale, string $group, ?string $namespace = '*'): array
    {
        $source = [];
        array_filter(
            $this->internalFileLoader->load($locale, '*', '*'),
            function ($translationKey) use ($group) {
                return Str::startsWith($translationKey, $group.'.') || Str::startsWith(
                    $translationKey,
                    'front::'.$group.'.'
                );
            },
            ARRAY_FILTER_USE_KEY
        );

        foreach ($this->internalFileLoader->load($locale, '*', '*') as $key => $translation) {
            if (Str::startsWith($key, $group.'.')) {
                $source[Str::after($key, $group.'.')] = $translation;
            }

            if (Str::startsWith($key, 'front::'.$group.'.')) {
                $source[Str::after($key, 'front::'.$group.'.')] = $translation;
            }
        }

        return $source;
    }
}
