<?php

declare(strict_types=1);

namespace Inside\I18n\Loaders;

use Inside\I18n\Services\FileLoader as InternalFileLoader;

/**
 * Class FileLoader
 */
class FileLoader extends AbstractLoader
{
    public function __construct(
        string $defaultLocale,
        protected InternalFileLoader $internalFileLoader
    ) {
        parent::__construct($defaultLocale);
    }

    public function loadSource(string $locale, string $group, ?string $namespace = '*'): array
    {
        return $this->internalFileLoader->load($locale, $group, $namespace);
    }

    /**
     * @param string $path
     */
    public function addJsonPath($path): void
    {
        $this->internalFileLoader->addJsonPath($path);
    }

    /**
     * @param string $namespace
     * @param string $hint
     */
    public function addNamespace($namespace, $hint)
    {
        $this->namespaces[$namespace] = $hint;
        $this->internalFileLoader->addNamespace($namespace, $hint);
    }
}
