<?php

declare(strict_types=1);

namespace Inside\I18n\Loaders;

use Inside\I18n\Cache\CacheRepositoryInterface;

/**
 * Class CacheLoader
 */
final class CacheLoader extends AbstractLoader
{
    public function __construct(
        string $defaultLocale,
        protected CacheRepositoryInterface $cache,
        protected AbstractLoader $fallbackLoader,
        protected int $cacheLifeTime
    ) {
        parent::__construct($defaultLocale);
    }

    public function loadSource(string $locale, string $group, ?string $namespace = '*'): array
    {
        if ($this->cache->has($locale, $group, $namespace)) {
            return $this->cache->get($locale, $group, $namespace) ?? [];
        } else {
            $source = $this->fallbackLoader->load($locale, $group, $namespace);
            $this->cache->put($locale, $group, $namespace, $source, $this->cacheLifeTime);

            return $source;
        }
    }

    public function addJsonPath($path): void
    {
        $this->fallbackLoader->addJsonPath($path);
    }

    public function addNamespace($namespace, $hint)
    {
        $this->fallbackLoader->addNamespace($namespace, $hint);
    }
}
