<?php

declare(strict_types=1);

namespace Inside\I18n\Loaders;

use Illuminate\Contracts\Translation\Loader as LoaderContract;

/**
 * Class AbstractLoader
 */
abstract class AbstractLoader implements LoaderContract
{
    protected array $namespaces = [];

    public function __construct(
        protected string $defaultLocale
    ) {
    }

    public function load($locale, $group, $namespace = null): array
    {
        if ($locale != $this->defaultLocale) {
            return array_replace_recursive(
                $this->loadSource($this->defaultLocale, $group, $namespace),
                $this->loadSource($locale, $group, $namespace)
            );
        }

        return $this->loadSource($locale, $group, $namespace);
    }

    /**
     * Load source
     */
    abstract public function loadSource(string $locale, string $group, ?string $namespace = null): array;

    /**
     * add json path
     *
     * @param  string  $path
     */
    abstract public function addJsonPath($path): void;

    /**
     * add a namespace
     *
     * @param  string  $namespace
     * @param  string  $hint
     */
    abstract public function addNamespace($namespace, $hint);

    public function namespaces(): array
    {
        return $this->namespaces;
    }
}
