<?php

namespace Inside\I18n\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

interface TranslatableContract
{
    public function hasTranslation(?string $locale = null): bool;

    public function getTranslation(?string $locale = null, bool $withFallback = null): ?Model;

    public function translation(): HasOne;

    public function translations(): HasMany;
}
