<?php

namespace Inside\I18n\Console\Commands;

use Inside\Console\Command;
use Inside\I18n\Repositories\TranslationRepository;

class TranslationsKeysCommand extends Command
{
    /** @var TranslationRepository */
    protected $translationRepository;

    protected $signature = 'inside:translation:keys';

    public function __construct(TranslationRepository $translationRepository)
    {
        parent::__construct();
        $this->translationRepository = $translationRepository;
    }

    public function handle(): void
    {
        $this->line('Clé;Français;Nouvelle Langue');
        $this->translationRepository->getAllKnownKeys()->transform(function ($info, $key) {
            /** @var string $translation */
            $translation = __($key, [], 'fr');
            if ($translation == $key) {
                return null;
            }

            return '"'.$key.'";"'.$translation.';"';
        })->filter()->each(function ($line) {
            $this->line($line);
        });
    }
}
