<?php

namespace Inside\I18n\Cache;

use Illuminate\Contracts\Cache\Store;
use ReflectionClass;

class CacheRepositoryFactory
{
    /**
     * @param Store $store
     * @param string $cacheTag
     * @return SimpleCacheRepository|TaggedCacheRepository
     */
    public static function make(Store $store, string $cacheTag)
    {
        $cacheReflection = new ReflectionClass(get_class($store));
        $storeParent = $cacheReflection->getParentClass();
        $parentName = $storeParent ? $storeParent->name : '';

        return $parentName == 'Illuminate\Cache\TaggableStore' ? new TaggedCacheRepository($store, $cacheTag)
            : new SimpleCacheRepository($store, $cacheTag);
    }
}
