<?php

namespace Inside\I18n\Cache;

use Illuminate\Contracts\Cache\Store;

abstract class AbstractCacheRepository implements CacheRepositoryInterface
{
    /**
     * @var Store
     */
    protected $store;

    /**
     * @var string
     */
    protected $cacheTag;

    /**
     * AbstractCacheRepository constructor.
     *
     * @param Store $store
     * @param string $cacheTag
     */
    public function __construct(Store $store, string $cacheTag)
    {
        $this->store = $store;
        $this->cacheTag = $cacheTag;
    }

    /**
     * @param string $locale
     * @param string $group
     * @param string|null $namespace
     * @return string
     */
    protected function getKey(string $locale, string $group, ?string $namespace)
    {
        return md5("{$this->cacheTag}-{$locale}-{$group}-{$namespace}");
    }
}
