<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateLiveTranslationsTable extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('inside_live_translations');

        Schema::create('inside_live_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('hash');
            $table->char('source_lang', 2);
            $table->char('target_lang', 2);
            $table->string('translator');
            $table->jsonb('translation')->nullable();
            $table->jsonb('original')->nullable();

            $table->index('id');
            $table->unique(['hash', 'target_lang']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_live_translations');
    }
}
