<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInsideCachedTranslationsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'inside_cached_translations',
            function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('language_id');
                $table->foreign('language_id')->references('id')->on('inside_languages');
                $table->enum('type', ['lumen', 'inside', 'back', 'modules', 'front', 'database', 'self']);
                $table->string('namespace', 150)->default('*')->index();
                $table->string('group', 150)->index();
                $table->string('key', 150);
                $table->text('text')->nullable();
                $table->text('original')->nullable();
                $table->boolean('translated')->default(false)->index();
                $table->timestamps();
                $table->unique(['language_id', 'namespace', 'group', 'key'], 'unique_cached_translation');
            }
        );
    }

    public function down(): void
    {
        Schema::drop('inside_cached_translations');
    }
}
