<?php

use Illuminate\Console\Scheduling\Schedule;
use Inside\I18n\Jobs\ClearLiveTranslations;

return [
    'clear_live_translations' => function (Schedule $schedule) {
        // clear live translations every 2 weeks on mondays
        $schedule
            ->job(new ClearLiveTranslations())
            ->mondays()
            ->when(fn () => now()->weekOfYear % 2)
            ->at('00:00');
    },
];
