<?php

use Illuminate\Support\Facades\Route;

Route::group([
    'prefix' => 'horizon/api',
    'namespace' => 'Inside\Horizon\Http\Controllers',
    'middleware' => 'auth.role:super_administrator',
],
    function ($router) {
        // Status Routes...
        $router->get('/status', ['uses' => 'StatusController@index', 'as' => 'horizon.status.index']);

        // Dashboard Routes...
        $router->get('/stats', ['uses' => 'DashboardStatsController@index', 'as' => 'horizon.stats.index']);

        // Workload Routes...
        $router->get('/workload', ['uses' => 'WorkloadController@index', 'as' => 'horizon.workload.index']);

        // Master Supervisor Routes...
        $router->get('/masters', ['uses' => 'MasterSupervisorController@index', 'as' => 'horizon.masters.index']);

        // Monitoring Routes...
        $router->get('/monitoring', ['uses' => 'MonitoringController@index', 'as' => 'horizon.monitoring.index']);
        $router->post('/monitoring', ['uses' => 'MonitoringController@store', 'as' => 'horizon.monitoring.store']);
        $router->get('/monitoring/{tag}', ['uses' => 'MonitoringController@paginate', 'as' => 'horizon.monitoring-tag.paginate']);
        $router->delete('/monitoring/{tag}', ['uses' => 'MonitoringController@destroy', 'as' => 'horizon.monitoring-tag.destroy']);

        // Job Metric Routes...
        $router->get('/metrics/jobs', ['uses' => 'JobMetricsController@index', 'as' => 'horizon.jobs-metrics.index']);
        $router->get('/metrics/jobs/{id}', ['uses' => 'JobMetricsController@show', 'as' => 'horizon.jobs-metrics.show']);

        // Queue Metric Routes...
        $router->get('/metrics/queues', ['uses' => 'QueueMetricsController@index', 'as' => 'horizon.queues-metrics.index']);
        $router->get('/metrics/queues/{id}', ['uses' => 'QueueMetricsController@show', 'as' => 'horizon.queues-metrics.show']);

        // Job Routes...
        $router->get('/jobs/recent', ['uses' => 'RecentJobsController@index', 'as' => 'horizon.recent-jobs.index']);
        $router->get('/jobs/recent/{id}', ['uses' => 'RecentJobsController@show', 'as' => 'horizon.recent-jobs.show']);
        $router->get('/jobs/failed', ['uses' => 'FailedJobsController@index', 'as' => 'horizon.failed-jobs.index']);
        $router->get('/jobs/failed/{id}', ['uses' => 'FailedJobsController@show', 'as' => 'horizon.failed-jobs.show']);
        $router->post('/jobs/retry/{id}', ['uses' => 'RetryController@store', 'as' => 'horizon.retry-jobs.show']);
    }
);

// Catch-all Route...
Route::get('horizon/[{view:.*}]', [
    'uses' => 'Inside\Horizon\Http\Controllers\HomeController@index',
    'as' => 'horizon.index',
    'middleware' => 'auth.role:super_administrator',
]);
