<?php

namespace Inside\Horizon\Listeners;

use Inside\Horizon\Contracts\JobRepository;
use Inside\Horizon\Events\JobPushed;

class StoreJob
{
    /**
     * The job repository implementation.
     *
     * @var \Inside\Horizon\Contracts\JobRepository
     */
    public $jobs;

    /**
     * Create a new listener instance.
     *
     * @param  \Inside\Horizon\Contracts\JobRepository  $jobs
     * @return void
     */
    public function __construct(JobRepository $jobs)
    {
        $this->jobs = $jobs;
    }

    /**
     * Handle the event.
     *
     * @param  \Inside\Horizon\Events\JobPushed  $event
     * @return void
     */
    public function handle(JobPushed $event)
    {
        $this->jobs->pushed(
            $event->connectionName, $event->queue, $event->payload
        );
    }
}
