<?php

namespace Inside\Horizon\Listeners;

use Inside\Horizon\Events\JobReserved;
use Inside\Horizon\Stopwatch;

class StartTimingJob
{
    /**
     * The stopwatch instance.
     *
     * @var \Inside\Horizon\Stopwatch
     */
    public $watch;

    /**
     * Create a new listener instance.
     *
     * @param  \Inside\Horizon\Stopwatch  $watch
     * @return void
     */
    public function __construct(Stopwatch $watch)
    {
        $this->watch = $watch;
    }

    /**
     * Handle the event.
     *
     * @param  \Inside\Horizon\Events\JobReserved  $event
     * @return void
     */
    public function handle(JobReserved $event)
    {
        $this->watch->start($event->payload->id());
    }
}
