<?php

namespace Inside\Horizon\Listeners;

use Inside\Horizon\Contracts\JobRepository;
use Inside\Horizon\Events\JobsMigrated;

class MarkJobsAsMigrated
{
    /**
     * The job repository implementation.
     *
     * @var \Inside\Horizon\Contracts\JobRepository
     */
    public $jobs;

    /**
     * Create a new listener instance.
     *
     * @param  \Inside\Horizon\Contracts\JobRepository  $jobs
     * @return void
     */
    public function __construct(JobRepository $jobs)
    {
        $this->jobs = $jobs;
    }

    /**
     * Handle the event.
     *
     * @param  \Inside\Horizon\Events\JobsMigrated  $event
     * @return void
     */
    public function handle(JobsMigrated $event)
    {
        $this->jobs->migrated($event->connectionName, $event->queue, $event->payloads);
    }
}
