<?php

namespace Inside\Horizon\Console;

use Inside\Console\Command;

class AssetsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'horizon:assets';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Re-publish the Horizon assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $links = collect([
            cms_base_path('storage/app/assets/horizon') => HORIZON_PATH.'/public',
        ]);

        if (! is_dir(cms_base_path('storage/app/assets'))) {
            $this->laravel->make('files')->makeDirectory(cms_base_path('storage/app/assets'), 0775, true);
        }

        $links->each(function ($origin, $symlink) {
            if (! is_link($symlink)) {
                $this->laravel->make('files')->link($origin, $symlink);

                $this->info("The [{$symlink}] horizon assets have been linked.");
            } else {
                unlink($symlink);
                $this->laravel->make('files')->link($origin, $symlink);

                $this->info("The [{$symlink}] horizon assets have been re-linked.");
            }
        });
    }
}
