<?php

namespace Illuminate\Database\Eloquent;

use ArrayAccess;
use JsonSerializable;

/**
 * @implements ArrayAccess<string, mixed>
 */
abstract class Model implements JsonSerializable, ArrayAccess
{
    /**
     * @var array<string, string>
     */
    protected array $casts = [];

    /**
     * @var list<string>
     */
    protected array $hidden = [];

    /**
     * @var list<string>
     */
    protected array $visible = [];

    /**
     *
     * @param  array<model-property<static>, mixed>  $attributes
     * @param  array<int|string, mixed>  $options
     * @return bool
     */
    public function update(array $attributes = [], array $options = []): bool;

    /**
     *
     * @param  string|array<int|string, (\Closure)|string|array<int|string, string>>  $relations
     * @return \Illuminate\Database\Eloquent\Builder<static>
     */
    public static function with(string|array $relations): Builder;
}

class ModelNotFoundException extends \RuntimeException {}
