<?php

namespace Illuminate\Database\Eloquent\Relations;

use Traversable;

/**
 * @template TRelatedModel of \Illuminate\Database\Eloquent\Model
 * @extends HasOneOrMany<TRelatedModel>
 */
class HasMany extends HasOneOrMany
{
    /**
     * Get the results of the relationship.
     *
     * @phpstan-return Traversable<int, TRelatedModel>
     */
    public function getResults(): Traversable;
}
